#python 3.7.0
from PIL import Image
import os
import numpy as np
import serial

UART_PORT = "COM4"
baudrate = 115200

rgb565_flow = []
image_num = 1
uart_send_len = 256
frame_to_send = [0]

def gif_to_images(gif_path, output_folder):
    # 打开 GIF 文件
    gif = Image.open(gif_path)

    # 确保输出文件夹存在
    if not os.path.exists(output_folder):
        os.makedirs(output_folder)

    # 获取 GIF 的帧数
    frame_count = gif.n_frames
    frame_to_send[0] = frame_count
    #print(frame_count)
    for frame in range(frame_count):
        # 设置当前帧
        gif.seek(frame)

        # 将当前帧保存为图像
        frame_image_path = os.path.join(output_folder, f"frame_{frame}.png")
        gif.save(frame_image_path, "PNG")
        print(f"Saved {frame_image_path}")

def image_to_rgb565_flow(img):
    arr = np.array(img)

    height = arr.shape[0]
    width = arr.shape[1]
    depth = arr.shape[2]
    if depth == 3:
        r, g, b = img.split()
    elif depth == 4:
        r, g, b, a = img.split()
    else:
        print('图片颜色格式错误')
        while(1):
            pass
    r = np.array(r)
    g = np.array(g)
    b = np.array(b)
    
    rgb565_flow.clear()

    r5 = 0
    g6 = 0
    b5 = 0
    
    for i in range(height):
        for j in range(width):
            r5 = int(r[i][j] / 8)
            g6 = int(g[i][j] / 4)
            b5 = int(b[i][j] / 8)
            
            H8 = int(r5 * 8 + g6 / 8)
            #print('H8 =',H8)
            L8 = int(int(g6 % 8) * 32 + b5)
            #print('L8 =',L8)
            
            rgb565_flow.append(H8)
            rgb565_flow.append(L8)
    
    print('图像数据长度：' + str(len(rgb565_flow)) + 'byte')
    if len(rgb565_flow) % 256 == 0:
        print('256byte对齐，发送数据长度：' + str(len(rgb565_flow)) + 'byte')
    else:
        add_len = int(256 - len(rgb565_flow) % 256)
        for i in range(add_len):
            rgb565_flow.append(0)
        print('非256byte对齐，发送数据长度：' + str(len(rgb565_flow)) + 'byte')

def send_rgb565_flow_by_uart():
    print('开始发送第' + str(image_num) + '帧')
    for i in range(int(len(rgb565_flow)/uart_send_len)):
        try:
            portx=UART_PORT
            bps=baudrate
            timex=20
            ser=serial.Serial(portx,bps,timeout=timex)
            
            result=ser.write(rgb565_flow[i*uart_send_len:(i+1)*uart_send_len])
            ser.read(1)
            ser.close()#关闭串口
        except Exception as e:
            print("---异常---：",e)
            break
    print('发送完成')
    print('')

if __name__ == "__main__":
    gif_path = "test.gif"      # 替换为你的 GIF 文件路径
    output_folder = "gif_png"  # 替换为你想保存帧图片的文件夹路径
    
    gif_to_images(gif_path, output_folder)
    print('')

    while(image_num < frame_to_send[0]):
        try:
            img = Image.open("gif_png/frame_" + str(image_num) + ".png")
            print('read' + str(image_num))
            image_to_rgb565_flow(img)
            send_rgb565_flow_by_uart()
            image_num = image_num + 1
        except IOError:
            print('error')
            break
    print('finish')
    
